
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega88P
;Program type             : Application
;Clock frequency          : 22,118000 MHz
;Memory model             : Small
;Optimize for             : Speed
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega88P
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1024
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _CV=R3
	.DEF _V=R5

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer1_compa_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_0x1A:
	.DB  0x0,0x0,0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x04
	.DW  0x03
	.DW  _0x1A*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x400)
	LDI  R25,HIGH(0x400)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;GPIOR0 INITIALIZATION
	LDI  R30,0x00
	OUT  GPIOR0,R30

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x4FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x4FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x200)
	LDI  R29,HIGH(0x200)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x200

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.04.4a Advanced
;Automatic Program Generator
; Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version : 3
;Date    : 07.05.2015
;Author  : SYR-ALEX
;Company :
;Comments: 512256  384256   
;
;
;Chip type               : ATmega88P
;Program type            : Application
;AVR Core Clock frequency: 22,118000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 256
;*****************************************************/
;
;#include <mega88p.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif
;
;#include <delay.h>
;
;#define Hs PORTB.2
;#define Vs PORTB.1
;#define Blank PORTB.3
;#define Strob PORTB.4
;#define Skr PINB.5        //   384\512
;#asm(".EQU PORTC=0x08")
	.EQU PORTC=0x08
;#asm(".EQU PORTB=0x05")
	.EQU PORTB=0x05
;
; unsigned int CV=0 ;//   
; int V=0;           //   
;
;
;
;// Timer1 output compare A interrupt service routine
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
; 0000 002B {

	.CSEG
_timer1_compa_isr:
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 002C   if ( CV==312 )
	LDI  R30,LOW(312)
	LDI  R31,HIGH(312)
	CP   R30,R3
	CPC  R31,R4
	BRNE _0x3
; 0000 002D          {
; 0000 002E          CV=0;
	CLR  R3
	CLR  R4
; 0000 002F                 delay_us(160);
	__DELAY_USW 885
; 0000 0030                     Hs=0;Vs=1;
	CBI  0x5,2
	SBI  0x5,1
; 0000 0031                         delay_us(160);
	__DELAY_USW 885
; 0000 0032                    Hs=1;Vs=0;
	SBI  0x5,2
	CBI  0x5,1
; 0000 0033                    // delay_us(100);
; 0000 0034                    goto L1;
	RJMP _0xC
; 0000 0035                     }
; 0000 0036                     else{
_0x3:
; 0000 0037                         if (CV<36)//   
	LDI  R30,LOW(36)
	LDI  R31,HIGH(36)
	CP   R3,R30
	CPC  R4,R31
	BRSH _0xE
; 0000 0038                         {
; 0000 0039                         V=0 ;
	CLR  R5
	CLR  R6
; 0000 003A                         //Blank=0;
; 0000 003B                         goto L1;
	RJMP _0xC
; 0000 003C                           }
; 0000 003D                          else{
_0xE:
; 0000 003E                           PORTD=V;
	OUT  0xB,R5
; 0000 003F                             if (V>255){
	LDI  R30,LOW(255)
	LDI  R31,HIGH(255)
	CP   R30,R5
	CPC  R31,R6
	BRGE _0x10
; 0000 0040                             //Blank=0;
; 0000 0041                             goto L1;}
	RJMP _0xC
; 0000 0042                                  //else{delay_us (4);}
; 0000 0043                                   }
_0x10:
; 0000 0044 
; 0000 0045       }
; 0000 0046       if (Skr==0){goto L384;}
	SBIS 0x3,5
	RJMP _0x12
; 0000 0047                else{goto L512;}
	RJMP _0x14
; 0000 0048   L384:
_0x12:
; 0000 0049   delay_us(11);
	__DELAY_USB 81
; 0000 004A  #asm
; 0000 004B 

; 0000 004C 

; 0000 004D    out PORTC,r19 ;1-0
   out PORTC,r19 ;1-0
; 0000 004E nop ;2
nop ;2
; 0000 004F nop ;3
nop ;3
; 0000 0050 nop ;4
nop ;4
; 0000 0051 nop ;5
nop ;5
; 0000 0052 nop ;6
nop ;6
; 0000 0053 nop ;7
nop ;7
; 0000 0054 nop ;8
nop ;8
; 0000 0055 nop ;9
nop ;9
; 0000 0056 cbi PORTB,4 ;10-11 Strob ON
cbi PORTB,4 ;10-11 Strob ON
; 0000 0057 SBI PORTB,4 ;12-13 Strob OFF
SBI PORTB,4 ;12-13 Strob OFF
; 0000 0058 SBI PORTB,3 ;14-15 Blank 1
SBI PORTB,3 ;14-15 Blank 1
; 0000 0059     inc r19 ;16
    inc r19 ;16
; 0000 005A     out PORTC,r19 ;1-1
    out PORTC,r19 ;1-1
; 0000 005B nop ;2
nop ;2
; 0000 005C nop ;3
nop ;3
; 0000 005D nop ;4
nop ;4
; 0000 005E nop ;5
nop ;5
; 0000 005F nop ;6
nop ;6
; 0000 0060 nop ;7
nop ;7
; 0000 0061 nop ;8
nop ;8
; 0000 0062 nop ;9
nop ;9
; 0000 0063 nop ;10
nop ;10
; 0000 0064 nop ;11
nop ;11
; 0000 0065 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0066 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0067     inc r19 ;16
    inc r19 ;16
; 0000 0068     out PORTC,r19 ;1-2
    out PORTC,r19 ;1-2
; 0000 0069 nop ;2
nop ;2
; 0000 006A nop ;3
nop ;3
; 0000 006B nop ;4
nop ;4
; 0000 006C nop ;5
nop ;5
; 0000 006D nop ;6
nop ;6
; 0000 006E nop ;7
nop ;7
; 0000 006F nop ;8
nop ;8
; 0000 0070 nop ;9
nop ;9
; 0000 0071 nop ;10
nop ;10
; 0000 0072 nop ;11
nop ;11
; 0000 0073 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0074 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0075     inc r19 ;16
    inc r19 ;16
; 0000 0076     out PORTC,r19 ;1-3
    out PORTC,r19 ;1-3
; 0000 0077 nop ;2
nop ;2
; 0000 0078 nop ;3
nop ;3
; 0000 0079 nop ;4
nop ;4
; 0000 007A nop ;5
nop ;5
; 0000 007B nop ;6
nop ;6
; 0000 007C nop ;7
nop ;7
; 0000 007D nop ;8
nop ;8
; 0000 007E nop ;9
nop ;9
; 0000 007F nop ;10
nop ;10
; 0000 0080 nop ;11
nop ;11
; 0000 0081 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0082 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0083     inc r19 ;16
    inc r19 ;16
; 0000 0084     out PORTC,r19 ;1-4
    out PORTC,r19 ;1-4
; 0000 0085 nop ;2
nop ;2
; 0000 0086 nop ;3
nop ;3
; 0000 0087 nop ;4
nop ;4
; 0000 0088 nop ;5
nop ;5
; 0000 0089 nop ;6
nop ;6
; 0000 008A nop ;7
nop ;7
; 0000 008B nop ;8
nop ;8
; 0000 008C nop ;9
nop ;9
; 0000 008D nop ;10
nop ;10
; 0000 008E nop ;11
nop ;11
; 0000 008F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0090 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0091     inc r19 ;16
    inc r19 ;16
; 0000 0092     out PORTC,r19 ;1-5
    out PORTC,r19 ;1-5
; 0000 0093 nop ;2
nop ;2
; 0000 0094 nop ;3
nop ;3
; 0000 0095 nop ;4
nop ;4
; 0000 0096 nop ;5
nop ;5
; 0000 0097 nop ;6
nop ;6
; 0000 0098 nop ;7
nop ;7
; 0000 0099 nop ;8
nop ;8
; 0000 009A nop ;9
nop ;9
; 0000 009B nop ;10
nop ;10
; 0000 009C nop ;11
nop ;11
; 0000 009D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 009E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 009F     inc r19 ;16
    inc r19 ;16
; 0000 00A0     out PORTC,r19 ;1-6
    out PORTC,r19 ;1-6
; 0000 00A1 nop ;2
nop ;2
; 0000 00A2 nop ;3
nop ;3
; 0000 00A3 nop ;4
nop ;4
; 0000 00A4 nop ;5
nop ;5
; 0000 00A5 nop ;6
nop ;6
; 0000 00A6 nop ;7
nop ;7
; 0000 00A7 nop ;8
nop ;8
; 0000 00A8 nop ;9
nop ;9
; 0000 00A9 nop ;10
nop ;10
; 0000 00AA nop ;11
nop ;11
; 0000 00AB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00AC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00AD     inc r19 ;16
    inc r19 ;16
; 0000 00AE     out PORTC,r19 ;1-7
    out PORTC,r19 ;1-7
; 0000 00AF nop ;2
nop ;2
; 0000 00B0 nop ;3
nop ;3
; 0000 00B1 nop ;4
nop ;4
; 0000 00B2 nop ;5
nop ;5
; 0000 00B3 nop ;6
nop ;6
; 0000 00B4 nop ;7
nop ;7
; 0000 00B5 nop ;8
nop ;8
; 0000 00B6 nop ;9
nop ;9
; 0000 00B7 nop ;10
nop ;10
; 0000 00B8 nop ;11
nop ;11
; 0000 00B9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00BA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00BB     inc r19 ;16
    inc r19 ;16
; 0000 00BC     out PORTC,r19 ;1-8
    out PORTC,r19 ;1-8
; 0000 00BD nop ;2
nop ;2
; 0000 00BE nop ;3
nop ;3
; 0000 00BF nop ;4
nop ;4
; 0000 00C0 nop ;5
nop ;5
; 0000 00C1 nop ;6
nop ;6
; 0000 00C2 nop ;7
nop ;7
; 0000 00C3 nop ;8
nop ;8
; 0000 00C4 nop ;9
nop ;9
; 0000 00C5 nop ;10
nop ;10
; 0000 00C6 nop ;11
nop ;11
; 0000 00C7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00C8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00C9     inc r19 ;16
    inc r19 ;16
; 0000 00CA     out PORTC,r19 ;1-9
    out PORTC,r19 ;1-9
; 0000 00CB nop ;2
nop ;2
; 0000 00CC nop ;3
nop ;3
; 0000 00CD nop ;4
nop ;4
; 0000 00CE nop ;5
nop ;5
; 0000 00CF nop ;6
nop ;6
; 0000 00D0 nop ;7
nop ;7
; 0000 00D1 nop ;8
nop ;8
; 0000 00D2 nop ;9
nop ;9
; 0000 00D3 nop ;10
nop ;10
; 0000 00D4 nop ;11
nop ;11
; 0000 00D5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00D6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00D7     inc r19 ;16
    inc r19 ;16
; 0000 00D8      out PORTC,r19 ;1-10
     out PORTC,r19 ;1-10
; 0000 00D9 nop ;2
nop ;2
; 0000 00DA nop ;3
nop ;3
; 0000 00DB nop ;4
nop ;4
; 0000 00DC nop ;5
nop ;5
; 0000 00DD nop ;6
nop ;6
; 0000 00DE nop ;7
nop ;7
; 0000 00DF nop ;8
nop ;8
; 0000 00E0 nop ;9
nop ;9
; 0000 00E1 nop ;10
nop ;10
; 0000 00E2 nop ;11
nop ;11
; 0000 00E3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00E4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00E5     inc r19 ;16
    inc r19 ;16
; 0000 00E6      out PORTC,r19 ;1-11
     out PORTC,r19 ;1-11
; 0000 00E7 nop ;2
nop ;2
; 0000 00E8 nop ;3
nop ;3
; 0000 00E9 nop ;4
nop ;4
; 0000 00EA nop ;5
nop ;5
; 0000 00EB nop ;6
nop ;6
; 0000 00EC nop ;7
nop ;7
; 0000 00ED nop ;8
nop ;8
; 0000 00EE nop ;9
nop ;9
; 0000 00EF nop ;10
nop ;10
; 0000 00F0 nop ;11
nop ;11
; 0000 00F1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 00F2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 00F3     inc r19 ;16
    inc r19 ;16
; 0000 00F4      out PORTC,r19 ;1-12
     out PORTC,r19 ;1-12
; 0000 00F5 nop ;2
nop ;2
; 0000 00F6 nop ;3
nop ;3
; 0000 00F7 nop ;4
nop ;4
; 0000 00F8 nop ;5
nop ;5
; 0000 00F9 nop ;6
nop ;6
; 0000 00FA nop ;7
nop ;7
; 0000 00FB nop ;8
nop ;8
; 0000 00FC nop ;9
nop ;9
; 0000 00FD nop ;10
nop ;10
; 0000 00FE nop ;11
nop ;11
; 0000 00FF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0100 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0101     inc r19 ;16
    inc r19 ;16
; 0000 0102      out PORTC,r19 ;1-13
     out PORTC,r19 ;1-13
; 0000 0103 nop ;2
nop ;2
; 0000 0104 nop ;3
nop ;3
; 0000 0105 nop ;4
nop ;4
; 0000 0106 nop ;5
nop ;5
; 0000 0107 nop ;6
nop ;6
; 0000 0108 nop ;7
nop ;7
; 0000 0109 nop ;8
nop ;8
; 0000 010A nop ;9
nop ;9
; 0000 010B nop ;10
nop ;10
; 0000 010C nop ;11
nop ;11
; 0000 010D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 010E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 010F     inc r19 ;16
    inc r19 ;16
; 0000 0110      out PORTC,r19 ;1-14
     out PORTC,r19 ;1-14
; 0000 0111 nop ;2
nop ;2
; 0000 0112 nop ;3
nop ;3
; 0000 0113 nop ;4
nop ;4
; 0000 0114 nop ;5
nop ;5
; 0000 0115 nop ;6
nop ;6
; 0000 0116 nop ;7
nop ;7
; 0000 0117 nop ;8
nop ;8
; 0000 0118 nop ;9
nop ;9
; 0000 0119 nop ;10
nop ;10
; 0000 011A nop ;11
nop ;11
; 0000 011B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 011C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 011D     inc r19 ;16
    inc r19 ;16
; 0000 011E      out PORTC,r19 ;1-15
     out PORTC,r19 ;1-15
; 0000 011F nop ;2
nop ;2
; 0000 0120 nop ;3
nop ;3
; 0000 0121 nop ;4
nop ;4
; 0000 0122 nop ;5
nop ;5
; 0000 0123 nop ;6
nop ;6
; 0000 0124 nop ;7
nop ;7
; 0000 0125 nop ;8
nop ;8
; 0000 0126 nop ;9
nop ;9
; 0000 0127 nop ;10
nop ;10
; 0000 0128 nop ;11
nop ;11
; 0000 0129 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 012A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 012B     inc r19 ;16
    inc r19 ;16
; 0000 012C     out PORTC,r19 ;1-16
    out PORTC,r19 ;1-16
; 0000 012D nop ;2
nop ;2
; 0000 012E nop ;3
nop ;3
; 0000 012F nop ;4
nop ;4
; 0000 0130 nop ;5
nop ;5
; 0000 0131 nop ;6
nop ;6
; 0000 0132 nop ;7
nop ;7
; 0000 0133 nop ;8
nop ;8
; 0000 0134 nop ;9
nop ;9
; 0000 0135 nop ;10
nop ;10
; 0000 0136 nop ;11
nop ;11
; 0000 0137 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0138 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0139     inc r19 ;16
    inc r19 ;16
; 0000 013A     out PORTC,r19 ;1-17
    out PORTC,r19 ;1-17
; 0000 013B nop ;2
nop ;2
; 0000 013C nop ;3
nop ;3
; 0000 013D nop ;4
nop ;4
; 0000 013E nop ;5
nop ;5
; 0000 013F nop ;6
nop ;6
; 0000 0140 nop ;7
nop ;7
; 0000 0141 nop ;8
nop ;8
; 0000 0142 nop ;9
nop ;9
; 0000 0143 nop ;10
nop ;10
; 0000 0144 nop ;11
nop ;11
; 0000 0145 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0146 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0147     inc r19 ;16
    inc r19 ;16
; 0000 0148      out PORTC,r19 ;1-18
     out PORTC,r19 ;1-18
; 0000 0149 nop ;2
nop ;2
; 0000 014A nop ;3
nop ;3
; 0000 014B nop ;4
nop ;4
; 0000 014C nop ;5
nop ;5
; 0000 014D nop ;6
nop ;6
; 0000 014E nop ;7
nop ;7
; 0000 014F nop ;8
nop ;8
; 0000 0150 nop ;9
nop ;9
; 0000 0151 nop ;10
nop ;10
; 0000 0152 nop ;11
nop ;11
; 0000 0153 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0154 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0155     inc r19 ;16
    inc r19 ;16
; 0000 0156      out PORTC,r19 ;1-19
     out PORTC,r19 ;1-19
; 0000 0157 nop ;2
nop ;2
; 0000 0158 nop ;3
nop ;3
; 0000 0159 nop ;4
nop ;4
; 0000 015A nop ;5
nop ;5
; 0000 015B nop ;6
nop ;6
; 0000 015C nop ;7
nop ;7
; 0000 015D nop ;8
nop ;8
; 0000 015E nop ;9
nop ;9
; 0000 015F nop ;10
nop ;10
; 0000 0160 nop ;11
nop ;11
; 0000 0161 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0162 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0163     inc r19 ;16
    inc r19 ;16
; 0000 0164      out PORTC,r19 ;1-20
     out PORTC,r19 ;1-20
; 0000 0165 nop ;2
nop ;2
; 0000 0166 nop ;3
nop ;3
; 0000 0167 nop ;4
nop ;4
; 0000 0168 nop ;5
nop ;5
; 0000 0169 nop ;6
nop ;6
; 0000 016A nop ;7
nop ;7
; 0000 016B nop ;8
nop ;8
; 0000 016C nop ;9
nop ;9
; 0000 016D nop ;10
nop ;10
; 0000 016E nop ;11
nop ;11
; 0000 016F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0170 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0171     inc r19 ;16
    inc r19 ;16
; 0000 0172      out PORTC,r19 ;1-21
     out PORTC,r19 ;1-21
; 0000 0173 nop ;2
nop ;2
; 0000 0174 nop ;3
nop ;3
; 0000 0175 nop ;4
nop ;4
; 0000 0176 nop ;5
nop ;5
; 0000 0177 nop ;6
nop ;6
; 0000 0178 nop ;7
nop ;7
; 0000 0179 nop ;8
nop ;8
; 0000 017A nop ;9
nop ;9
; 0000 017B nop ;10
nop ;10
; 0000 017C nop ;11
nop ;11
; 0000 017D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 017E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 017F     inc r19 ;16
    inc r19 ;16
; 0000 0180      out PORTC,r19 ;1-22
     out PORTC,r19 ;1-22
; 0000 0181 nop ;2
nop ;2
; 0000 0182 nop ;3
nop ;3
; 0000 0183 nop ;4
nop ;4
; 0000 0184 nop ;5
nop ;5
; 0000 0185 nop ;6
nop ;6
; 0000 0186 nop ;7
nop ;7
; 0000 0187 nop ;8
nop ;8
; 0000 0188 nop ;9
nop ;9
; 0000 0189 nop ;10
nop ;10
; 0000 018A nop ;11
nop ;11
; 0000 018B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 018C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 018D     inc r19 ;16
    inc r19 ;16
; 0000 018E     out PORTC,r19 ;1-23
    out PORTC,r19 ;1-23
; 0000 018F nop ;2
nop ;2
; 0000 0190 nop ;3
nop ;3
; 0000 0191 nop ;4
nop ;4
; 0000 0192 nop ;5
nop ;5
; 0000 0193 nop ;6
nop ;6
; 0000 0194 nop ;7
nop ;7
; 0000 0195 nop ;8
nop ;8
; 0000 0196 nop ;9
nop ;9
; 0000 0197 nop ;10
nop ;10
; 0000 0198 nop ;11
nop ;11
; 0000 0199 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 019A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 019B     inc r19 ;16
    inc r19 ;16
; 0000 019C      out PORTC,r19 ;1-24
     out PORTC,r19 ;1-24
; 0000 019D nop ;2
nop ;2
; 0000 019E nop ;3
nop ;3
; 0000 019F nop ;4
nop ;4
; 0000 01A0 nop ;5
nop ;5
; 0000 01A1 nop ;6
nop ;6
; 0000 01A2 nop ;7
nop ;7
; 0000 01A3 nop ;8
nop ;8
; 0000 01A4 nop ;9
nop ;9
; 0000 01A5 nop ;10
nop ;10
; 0000 01A6 nop ;11
nop ;11
; 0000 01A7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01A8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01A9     inc r19 ;16
    inc r19 ;16
; 0000 01AA     out PORTC,r19 ;1-25
    out PORTC,r19 ;1-25
; 0000 01AB nop ;2
nop ;2
; 0000 01AC nop ;3
nop ;3
; 0000 01AD nop ;4
nop ;4
; 0000 01AE nop ;5
nop ;5
; 0000 01AF nop ;6
nop ;6
; 0000 01B0 nop ;7
nop ;7
; 0000 01B1 nop ;8
nop ;8
; 0000 01B2 nop ;9
nop ;9
; 0000 01B3 nop ;10
nop ;10
; 0000 01B4 nop ;11
nop ;11
; 0000 01B5 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01B6 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01B7     inc r19 ;16
    inc r19 ;16
; 0000 01B8     out PORTC,r19 ;1-26
    out PORTC,r19 ;1-26
; 0000 01B9 nop ;2
nop ;2
; 0000 01BA nop ;3
nop ;3
; 0000 01BB nop ;4
nop ;4
; 0000 01BC nop ;5
nop ;5
; 0000 01BD nop ;6
nop ;6
; 0000 01BE nop ;7
nop ;7
; 0000 01BF nop ;8
nop ;8
; 0000 01C0 nop ;9
nop ;9
; 0000 01C1 nop ;10
nop ;10
; 0000 01C2 nop ;11
nop ;11
; 0000 01C3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01C4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01C5     inc r19 ;16
    inc r19 ;16
; 0000 01C6     out PORTC,r19 ;1-27
    out PORTC,r19 ;1-27
; 0000 01C7 nop ;2
nop ;2
; 0000 01C8 nop ;3
nop ;3
; 0000 01C9 nop ;4
nop ;4
; 0000 01CA nop ;5
nop ;5
; 0000 01CB nop ;6
nop ;6
; 0000 01CC nop ;7
nop ;7
; 0000 01CD nop ;8
nop ;8
; 0000 01CE nop ;9
nop ;9
; 0000 01CF nop ;10
nop ;10
; 0000 01D0 nop ;11
nop ;11
; 0000 01D1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01D2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01D3     inc r19 ;16
    inc r19 ;16
; 0000 01D4     out PORTC,r19 ;1-28
    out PORTC,r19 ;1-28
; 0000 01D5 nop ;2
nop ;2
; 0000 01D6 nop ;3
nop ;3
; 0000 01D7 nop ;4
nop ;4
; 0000 01D8 nop ;5
nop ;5
; 0000 01D9 nop ;6
nop ;6
; 0000 01DA nop ;7
nop ;7
; 0000 01DB nop ;8
nop ;8
; 0000 01DC nop ;9
nop ;9
; 0000 01DD nop ;10
nop ;10
; 0000 01DE nop ;11
nop ;11
; 0000 01DF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01E0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01E1     inc r19 ;16
    inc r19 ;16
; 0000 01E2      out PORTC,r19 ;1-29
     out PORTC,r19 ;1-29
; 0000 01E3 nop ;2
nop ;2
; 0000 01E4 nop ;3
nop ;3
; 0000 01E5 nop ;4
nop ;4
; 0000 01E6 nop ;5
nop ;5
; 0000 01E7 nop ;6
nop ;6
; 0000 01E8 nop ;7
nop ;7
; 0000 01E9 nop ;8
nop ;8
; 0000 01EA nop ;9
nop ;9
; 0000 01EB nop ;10
nop ;10
; 0000 01EC nop ;11
nop ;11
; 0000 01ED cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01EE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01EF     inc r19 ;16
    inc r19 ;16
; 0000 01F0      out PORTC,r19 ;1-30
     out PORTC,r19 ;1-30
; 0000 01F1 nop ;2
nop ;2
; 0000 01F2 nop ;3
nop ;3
; 0000 01F3 nop ;4
nop ;4
; 0000 01F4 nop ;5
nop ;5
; 0000 01F5 nop ;6
nop ;6
; 0000 01F6 nop ;7
nop ;7
; 0000 01F7 nop ;8
nop ;8
; 0000 01F8 nop ;9
nop ;9
; 0000 01F9 nop ;10
nop ;10
; 0000 01FA nop ;11
nop ;11
; 0000 01FB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 01FC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 01FD     inc r19 ;16
    inc r19 ;16
; 0000 01FE      out PORTC,r19 ;1-31
     out PORTC,r19 ;1-31
; 0000 01FF nop ;2
nop ;2
; 0000 0200 nop ;3
nop ;3
; 0000 0201 nop ;4
nop ;4
; 0000 0202 nop ;5
nop ;5
; 0000 0203 nop ;6
nop ;6
; 0000 0204 nop ;7
nop ;7
; 0000 0205 nop ;8
nop ;8
; 0000 0206 nop ;9
nop ;9
; 0000 0207 nop ;10
nop ;10
; 0000 0208 nop ;11
nop ;11
; 0000 0209 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 020A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 020B     inc r19 ;16
    inc r19 ;16
; 0000 020C      out PORTC,r19 ;1-32
     out PORTC,r19 ;1-32
; 0000 020D nop ;2
nop ;2
; 0000 020E nop ;3
nop ;3
; 0000 020F nop ;4
nop ;4
; 0000 0210 nop ;5
nop ;5
; 0000 0211 nop ;6
nop ;6
; 0000 0212 nop ;7
nop ;7
; 0000 0213 nop ;8
nop ;8
; 0000 0214 nop ;9
nop ;9
; 0000 0215 nop ;10
nop ;10
; 0000 0216 nop ;11
nop ;11
; 0000 0217 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0218 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0219     inc r19 ;16
    inc r19 ;16
; 0000 021A     out PORTC,r19 ;1-33
    out PORTC,r19 ;1-33
; 0000 021B nop ;2
nop ;2
; 0000 021C nop ;3
nop ;3
; 0000 021D nop ;4
nop ;4
; 0000 021E nop ;5
nop ;5
; 0000 021F nop ;6
nop ;6
; 0000 0220 nop ;7
nop ;7
; 0000 0221 nop ;8
nop ;8
; 0000 0222 nop ;9
nop ;9
; 0000 0223 nop ;10
nop ;10
; 0000 0224 nop ;11
nop ;11
; 0000 0225 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0226 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0227     inc r19 ;16
    inc r19 ;16
; 0000 0228      out PORTC,r19 ;1-34
     out PORTC,r19 ;1-34
; 0000 0229 nop ;2
nop ;2
; 0000 022A nop ;3
nop ;3
; 0000 022B nop ;4
nop ;4
; 0000 022C nop ;5
nop ;5
; 0000 022D nop ;6
nop ;6
; 0000 022E nop ;7
nop ;7
; 0000 022F nop ;8
nop ;8
; 0000 0230 nop ;9
nop ;9
; 0000 0231 nop ;10
nop ;10
; 0000 0232 nop ;11
nop ;11
; 0000 0233 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0234 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0235     inc r19 ;16
    inc r19 ;16
; 0000 0236      out PORTC,r19 ;1-35
     out PORTC,r19 ;1-35
; 0000 0237 nop ;2
nop ;2
; 0000 0238 nop ;3
nop ;3
; 0000 0239 nop ;4
nop ;4
; 0000 023A nop ;5
nop ;5
; 0000 023B nop ;6
nop ;6
; 0000 023C nop ;7
nop ;7
; 0000 023D nop ;8
nop ;8
; 0000 023E nop ;9
nop ;9
; 0000 023F nop ;10
nop ;10
; 0000 0240 nop ;11
nop ;11
; 0000 0241 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0242 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0243     inc r19 ;16
    inc r19 ;16
; 0000 0244      out PORTC,r19 ;1-36
     out PORTC,r19 ;1-36
; 0000 0245 nop ;2
nop ;2
; 0000 0246 nop ;3
nop ;3
; 0000 0247 nop ;4
nop ;4
; 0000 0248 nop ;5
nop ;5
; 0000 0249 nop ;6
nop ;6
; 0000 024A nop ;7
nop ;7
; 0000 024B nop ;8
nop ;8
; 0000 024C nop ;9
nop ;9
; 0000 024D nop ;10
nop ;10
; 0000 024E nop ;11
nop ;11
; 0000 024F cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0250 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0251     inc r19 ;16
    inc r19 ;16
; 0000 0252      out PORTC,r19 ;1-37
     out PORTC,r19 ;1-37
; 0000 0253 nop ;2
nop ;2
; 0000 0254 nop ;3
nop ;3
; 0000 0255 nop ;4
nop ;4
; 0000 0256 nop ;5
nop ;5
; 0000 0257 nop ;6
nop ;6
; 0000 0258 nop ;7
nop ;7
; 0000 0259 nop ;8
nop ;8
; 0000 025A nop ;9
nop ;9
; 0000 025B nop ;10
nop ;10
; 0000 025C nop ;11
nop ;11
; 0000 025D cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 025E SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 025F     inc r19 ;16
    inc r19 ;16
; 0000 0260      out PORTC,r19 ;1-38
     out PORTC,r19 ;1-38
; 0000 0261 nop ;2
nop ;2
; 0000 0262 nop ;3
nop ;3
; 0000 0263 nop ;4
nop ;4
; 0000 0264 nop ;5
nop ;5
; 0000 0265 nop ;6
nop ;6
; 0000 0266 nop ;7
nop ;7
; 0000 0267 nop ;8
nop ;8
; 0000 0268 nop ;9
nop ;9
; 0000 0269 nop ;10
nop ;10
; 0000 026A nop ;11
nop ;11
; 0000 026B cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 026C SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 026D     inc r19 ;16
    inc r19 ;16
; 0000 026E      out PORTC,r19 ;1-39
     out PORTC,r19 ;1-39
; 0000 026F nop ;2
nop ;2
; 0000 0270 nop ;3
nop ;3
; 0000 0271 nop ;4
nop ;4
; 0000 0272 nop ;5
nop ;5
; 0000 0273 nop ;6
nop ;6
; 0000 0274 nop ;7
nop ;7
; 0000 0275 nop ;8
nop ;8
; 0000 0276 nop ;9
nop ;9
; 0000 0277 nop ;10
nop ;10
; 0000 0278 nop ;11
nop ;11
; 0000 0279 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 027A SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 027B     inc r19 ;16
    inc r19 ;16
; 0000 027C      out PORTC,r19 ;1-40
     out PORTC,r19 ;1-40
; 0000 027D nop ;2
nop ;2
; 0000 027E nop ;3
nop ;3
; 0000 027F nop ;4
nop ;4
; 0000 0280 nop ;5
nop ;5
; 0000 0281 nop ;6
nop ;6
; 0000 0282 nop ;7
nop ;7
; 0000 0283 nop ;8
nop ;8
; 0000 0284 nop ;9
nop ;9
; 0000 0285 nop ;10
nop ;10
; 0000 0286 nop ;11
nop ;11
; 0000 0287 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0288 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0289     inc r19 ;16
    inc r19 ;16
; 0000 028A      out PORTC,r19 ;1-41
     out PORTC,r19 ;1-41
; 0000 028B nop ;2
nop ;2
; 0000 028C nop ;3
nop ;3
; 0000 028D nop ;4
nop ;4
; 0000 028E nop ;5
nop ;5
; 0000 028F nop ;6
nop ;6
; 0000 0290 nop ;7
nop ;7
; 0000 0291 nop ;8
nop ;8
; 0000 0292 nop ;9
nop ;9
; 0000 0293 nop ;10
nop ;10
; 0000 0294 nop ;11
nop ;11
; 0000 0295 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0296 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0297     inc r19 ;16
    inc r19 ;16
; 0000 0298      out PORTC,r19 ;1-42
     out PORTC,r19 ;1-42
; 0000 0299 nop ;2
nop ;2
; 0000 029A nop ;3
nop ;3
; 0000 029B nop ;4
nop ;4
; 0000 029C nop ;5
nop ;5
; 0000 029D nop ;6
nop ;6
; 0000 029E nop ;7
nop ;7
; 0000 029F nop ;8
nop ;8
; 0000 02A0 nop ;9
nop ;9
; 0000 02A1 nop ;10
nop ;10
; 0000 02A2 nop ;11
nop ;11
; 0000 02A3 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02A4 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02A5     inc r19 ;16
    inc r19 ;16
; 0000 02A6      out PORTC,r19 ;1-43
     out PORTC,r19 ;1-43
; 0000 02A7 nop ;2
nop ;2
; 0000 02A8 nop ;3
nop ;3
; 0000 02A9 nop ;4
nop ;4
; 0000 02AA nop ;5
nop ;5
; 0000 02AB nop ;6
nop ;6
; 0000 02AC nop ;7
nop ;7
; 0000 02AD nop ;8
nop ;8
; 0000 02AE nop ;9
nop ;9
; 0000 02AF nop ;10
nop ;10
; 0000 02B0 nop ;11
nop ;11
; 0000 02B1 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02B2 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02B3     inc r19 ;16
    inc r19 ;16
; 0000 02B4      out PORTC,r19 ;1-44
     out PORTC,r19 ;1-44
; 0000 02B5 nop ;2
nop ;2
; 0000 02B6 nop ;3
nop ;3
; 0000 02B7 nop ;4
nop ;4
; 0000 02B8 nop ;5
nop ;5
; 0000 02B9 nop ;6
nop ;6
; 0000 02BA nop ;7
nop ;7
; 0000 02BB nop ;8
nop ;8
; 0000 02BC nop ;9
nop ;9
; 0000 02BD nop ;10
nop ;10
; 0000 02BE nop ;11
nop ;11
; 0000 02BF cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02C0 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02C1     inc r19 ;16
    inc r19 ;16
; 0000 02C2      out PORTC,r19 ;1-45
     out PORTC,r19 ;1-45
; 0000 02C3 nop ;2
nop ;2
; 0000 02C4 nop ;3
nop ;3
; 0000 02C5 nop ;4
nop ;4
; 0000 02C6 nop ;5
nop ;5
; 0000 02C7 nop ;6
nop ;6
; 0000 02C8 nop ;7
nop ;7
; 0000 02C9 nop ;8
nop ;8
; 0000 02CA nop ;9
nop ;9
; 0000 02CB nop ;10
nop ;10
; 0000 02CC nop ;11
nop ;11
; 0000 02CD cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02CE SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02CF     inc r19 ;16
    inc r19 ;16
; 0000 02D0      out PORTC,r19 ;1-46
     out PORTC,r19 ;1-46
; 0000 02D1 nop ;2
nop ;2
; 0000 02D2 nop ;3
nop ;3
; 0000 02D3 nop ;4
nop ;4
; 0000 02D4 nop ;5
nop ;5
; 0000 02D5 nop ;6
nop ;6
; 0000 02D6 nop ;7
nop ;7
; 0000 02D7 nop ;8
nop ;8
; 0000 02D8 nop ;9
nop ;9
; 0000 02D9 nop ;10
nop ;10
; 0000 02DA nop ;11
nop ;11
; 0000 02DB cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02DC SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02DD     inc r19 ;16
    inc r19 ;16
; 0000 02DE     out PORTC,r19 ;1-47
    out PORTC,r19 ;1-47
; 0000 02DF nop ;2
nop ;2
; 0000 02E0 nop ;3
nop ;3
; 0000 02E1 nop ;4
nop ;4
; 0000 02E2 nop ;5
nop ;5
; 0000 02E3 nop ;6
nop ;6
; 0000 02E4 nop ;7
nop ;7
; 0000 02E5 nop ;8
nop ;8
; 0000 02E6 nop ;9
nop ;9
; 0000 02E7 nop ;10
nop ;10
; 0000 02E8 nop ;11
nop ;11
; 0000 02E9 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02EA SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02EB     inc r19 ;16
    inc r19 ;16
; 0000 02EC     out PORTC,r19 ;1-48
    out PORTC,r19 ;1-48
; 0000 02ED nop ;2
nop ;2
; 0000 02EE nop ;3
nop ;3
; 0000 02EF nop ;4
nop ;4
; 0000 02F0 nop ;5
nop ;5
; 0000 02F1 nop ;6
nop ;6
; 0000 02F2 nop ;7
nop ;7
; 0000 02F3 nop ;8
nop ;8
; 0000 02F4 nop ;9
nop ;9
; 0000 02F5 nop ;10
nop ;10
; 0000 02F6 nop ;11
nop ;11
; 0000 02F7 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 02F8 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 02F9 nop ;16
nop ;16
; 0000 02FA nop ;1
nop ;1
; 0000 02FB nop ;2
nop ;2
; 0000 02FC nop ;3
nop ;3
; 0000 02FD nop ;4
nop ;4
; 0000 02FE nop ;5
nop ;5
; 0000 02FF nop ;6
nop ;6
; 0000 0300 nop ;7
nop ;7
; 0000 0301 nop ;8
nop ;8
; 0000 0302 nop ;9
nop ;9
; 0000 0303 nop ;10
nop ;10
; 0000 0304 nop ;11
nop ;11
; 0000 0305 nop ;12
nop ;12
; 0000 0306 nop ;13
nop ;13
; 0000 0307 nop ;14
nop ;14
; 0000 0308 nop ;15
nop ;15
; 0000 0309 nop ;15
nop ;15
; 0000 030A cbi  PORTB,3;16-17  Blank =0
cbi  PORTB,3;16-17  Blank =0
; 0000 030B     ldi r19,15 ;18  ""
    ldi r19,15 ;18  ""
; 0000 030C     //clr r19 ;18  " 128"
    //clr r19 ;18  " 128"
; 0000 030D     out PORTC,r19 ;19
    out PORTC,r19 ;19
; 0000 030E 

; 0000 030F #endasm
; 0000 0310 goto L2;
	RJMP _0x15
; 0000 0311   L512:
_0x14:
; 0000 0312  delay_us(6);
	__DELAY_USB 44
; 0000 0313  #asm
; 0000 0314 

; 0000 0315 

; 0000 0316     out PORTC,r19 ;1-0
    out PORTC,r19 ;1-0
; 0000 0317 nop ;2
nop ;2
; 0000 0318 nop ;3
nop ;3
; 0000 0319 nop ;4
nop ;4
; 0000 031A nop ;5
nop ;5
; 0000 031B nop ;6
nop ;6
; 0000 031C nop ;7
nop ;7
; 0000 031D nop ;8
nop ;8
; 0000 031E nop ;9
nop ;9
; 0000 031F cbi PORTB,4 ;10-11 Strob ON
cbi PORTB,4 ;10-11 Strob ON
; 0000 0320 SBI PORTB,4 ;12-13 Strob OFF
SBI PORTB,4 ;12-13 Strob OFF
; 0000 0321 SBI PORTB,3 ;14-15 Blank 1
SBI PORTB,3 ;14-15 Blank 1
; 0000 0322     inc r19 ;16
    inc r19 ;16
; 0000 0323     out PORTC,r19 ;1-1
    out PORTC,r19 ;1-1
; 0000 0324 nop ;2
nop ;2
; 0000 0325 nop ;3
nop ;3
; 0000 0326 nop ;4
nop ;4
; 0000 0327 nop ;5
nop ;5
; 0000 0328 nop ;6
nop ;6
; 0000 0329 nop ;7
nop ;7
; 0000 032A nop ;8
nop ;8
; 0000 032B nop ;9
nop ;9
; 0000 032C nop ;10
nop ;10
; 0000 032D nop ;11
nop ;11
; 0000 032E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 032F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0330     inc r19 ;16
    inc r19 ;16
; 0000 0331     out PORTC,r19 ;1-2
    out PORTC,r19 ;1-2
; 0000 0332 nop ;2
nop ;2
; 0000 0333 nop ;3
nop ;3
; 0000 0334 nop ;4
nop ;4
; 0000 0335 nop ;5
nop ;5
; 0000 0336 nop ;6
nop ;6
; 0000 0337 nop ;7
nop ;7
; 0000 0338 nop ;8
nop ;8
; 0000 0339 nop ;9
nop ;9
; 0000 033A nop ;10
nop ;10
; 0000 033B nop ;11
nop ;11
; 0000 033C cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 033D SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 033E     inc r19 ;16
    inc r19 ;16
; 0000 033F     out PORTC,r19 ;1        3
    out PORTC,r19 ;1        3
; 0000 0340 nop ;2
nop ;2
; 0000 0341 nop ;3
nop ;3
; 0000 0342 nop ;4
nop ;4
; 0000 0343 nop ;5
nop ;5
; 0000 0344 nop ;6
nop ;6
; 0000 0345 nop ;7
nop ;7
; 0000 0346 nop ;8
nop ;8
; 0000 0347 nop ;9
nop ;9
; 0000 0348 nop ;10
nop ;10
; 0000 0349 nop ;11
nop ;11
; 0000 034A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 034B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 034C     inc r19 ;16
    inc r19 ;16
; 0000 034D     out PORTC,r19 ;1-4
    out PORTC,r19 ;1-4
; 0000 034E nop ;2
nop ;2
; 0000 034F nop ;3
nop ;3
; 0000 0350 nop ;4
nop ;4
; 0000 0351 nop ;5
nop ;5
; 0000 0352 nop ;6
nop ;6
; 0000 0353 nop ;7
nop ;7
; 0000 0354 nop ;8
nop ;8
; 0000 0355 nop ;9
nop ;9
; 0000 0356 nop ;10
nop ;10
; 0000 0357 nop ;11
nop ;11
; 0000 0358 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0359 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 035A     inc r19 ;16
    inc r19 ;16
; 0000 035B     out PORTC,r19 ;1-5
    out PORTC,r19 ;1-5
; 0000 035C nop ;2
nop ;2
; 0000 035D nop ;3
nop ;3
; 0000 035E nop ;4
nop ;4
; 0000 035F nop ;5
nop ;5
; 0000 0360 nop ;6
nop ;6
; 0000 0361 nop ;7
nop ;7
; 0000 0362 nop ;8
nop ;8
; 0000 0363 nop ;9
nop ;9
; 0000 0364 nop ;10
nop ;10
; 0000 0365 nop ;11
nop ;11
; 0000 0366 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0367 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0368     inc r19 ;16
    inc r19 ;16
; 0000 0369     out PORTC,r19 ;1-6
    out PORTC,r19 ;1-6
; 0000 036A nop ;2
nop ;2
; 0000 036B nop ;3
nop ;3
; 0000 036C nop ;4
nop ;4
; 0000 036D nop ;5
nop ;5
; 0000 036E nop ;6
nop ;6
; 0000 036F nop ;7
nop ;7
; 0000 0370 nop ;8
nop ;8
; 0000 0371 nop ;9
nop ;9
; 0000 0372 nop ;10
nop ;10
; 0000 0373 nop ;11
nop ;11
; 0000 0374 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0375 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0376     inc r19 ;16
    inc r19 ;16
; 0000 0377     out PORTC,r19 ;1-7
    out PORTC,r19 ;1-7
; 0000 0378 nop ;2
nop ;2
; 0000 0379 nop ;3
nop ;3
; 0000 037A nop ;4
nop ;4
; 0000 037B nop ;5
nop ;5
; 0000 037C nop ;6
nop ;6
; 0000 037D nop ;7
nop ;7
; 0000 037E nop ;8
nop ;8
; 0000 037F nop ;9
nop ;9
; 0000 0380 nop ;10
nop ;10
; 0000 0381 nop ;11
nop ;11
; 0000 0382 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0383 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0384     inc r19 ;16
    inc r19 ;16
; 0000 0385     out PORTC,r19 ;1-8
    out PORTC,r19 ;1-8
; 0000 0386 nop ;2
nop ;2
; 0000 0387 nop ;3
nop ;3
; 0000 0388 nop ;4
nop ;4
; 0000 0389 nop ;5
nop ;5
; 0000 038A nop ;6
nop ;6
; 0000 038B nop ;7
nop ;7
; 0000 038C nop ;8
nop ;8
; 0000 038D nop ;9
nop ;9
; 0000 038E nop ;10
nop ;10
; 0000 038F nop ;11
nop ;11
; 0000 0390 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0391 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0392     inc r19 ;16
    inc r19 ;16
; 0000 0393     out PORTC,r19 ;1-9
    out PORTC,r19 ;1-9
; 0000 0394 nop ;2
nop ;2
; 0000 0395 nop ;3
nop ;3
; 0000 0396 nop ;4
nop ;4
; 0000 0397 nop ;5
nop ;5
; 0000 0398 nop ;6
nop ;6
; 0000 0399 nop ;7
nop ;7
; 0000 039A nop ;8
nop ;8
; 0000 039B nop ;9
nop ;9
; 0000 039C nop ;10
nop ;10
; 0000 039D nop ;11
nop ;11
; 0000 039E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 039F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03A0     inc r19 ;16
    inc r19 ;16
; 0000 03A1      out PORTC,r19 ;1-10
     out PORTC,r19 ;1-10
; 0000 03A2 nop ;2
nop ;2
; 0000 03A3 nop ;3
nop ;3
; 0000 03A4 nop ;4
nop ;4
; 0000 03A5 nop ;5
nop ;5
; 0000 03A6 nop ;6
nop ;6
; 0000 03A7 nop ;7
nop ;7
; 0000 03A8 nop ;8
nop ;8
; 0000 03A9 nop ;9
nop ;9
; 0000 03AA nop ;10
nop ;10
; 0000 03AB nop ;11
nop ;11
; 0000 03AC cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03AD SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03AE     inc r19 ;16
    inc r19 ;16
; 0000 03AF      out PORTC,r19 ;1-11
     out PORTC,r19 ;1-11
; 0000 03B0 nop ;2
nop ;2
; 0000 03B1 nop ;3
nop ;3
; 0000 03B2 nop ;4
nop ;4
; 0000 03B3 nop ;5
nop ;5
; 0000 03B4 nop ;6
nop ;6
; 0000 03B5 nop ;7
nop ;7
; 0000 03B6 nop ;8
nop ;8
; 0000 03B7 nop ;9
nop ;9
; 0000 03B8 nop ;10
nop ;10
; 0000 03B9 nop ;11
nop ;11
; 0000 03BA cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03BB SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03BC     inc r19 ;16
    inc r19 ;16
; 0000 03BD      out PORTC,r19 ;1-12
     out PORTC,r19 ;1-12
; 0000 03BE nop ;2
nop ;2
; 0000 03BF nop ;3
nop ;3
; 0000 03C0 nop ;4
nop ;4
; 0000 03C1 nop ;5
nop ;5
; 0000 03C2 nop ;6
nop ;6
; 0000 03C3 nop ;7
nop ;7
; 0000 03C4 nop ;8
nop ;8
; 0000 03C5 nop ;9
nop ;9
; 0000 03C6 nop ;10
nop ;10
; 0000 03C7 nop ;11
nop ;11
; 0000 03C8 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03C9 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03CA     inc r19 ;16
    inc r19 ;16
; 0000 03CB      out PORTC,r19 ;1-13
     out PORTC,r19 ;1-13
; 0000 03CC nop ;2
nop ;2
; 0000 03CD nop ;3
nop ;3
; 0000 03CE nop ;4
nop ;4
; 0000 03CF nop ;5
nop ;5
; 0000 03D0 nop ;6
nop ;6
; 0000 03D1 nop ;7
nop ;7
; 0000 03D2 nop ;8
nop ;8
; 0000 03D3 nop ;9
nop ;9
; 0000 03D4 nop ;10
nop ;10
; 0000 03D5 nop ;11
nop ;11
; 0000 03D6 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03D7 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03D8     inc r19 ;16
    inc r19 ;16
; 0000 03D9     out PORTC,r19 ;1-14
    out PORTC,r19 ;1-14
; 0000 03DA nop ;2
nop ;2
; 0000 03DB nop ;3
nop ;3
; 0000 03DC nop ;4
nop ;4
; 0000 03DD nop ;5
nop ;5
; 0000 03DE nop ;6
nop ;6
; 0000 03DF nop ;7
nop ;7
; 0000 03E0 nop ;8
nop ;8
; 0000 03E1 nop ;9
nop ;9
; 0000 03E2 nop ;10
nop ;10
; 0000 03E3 nop ;11
nop ;11
; 0000 03E4 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03E5 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03E6     inc r19 ;16
    inc r19 ;16
; 0000 03E7      out PORTC,r19 ;1-15
     out PORTC,r19 ;1-15
; 0000 03E8 nop ;2
nop ;2
; 0000 03E9 nop ;3
nop ;3
; 0000 03EA nop ;4
nop ;4
; 0000 03EB nop ;5
nop ;5
; 0000 03EC nop ;6
nop ;6
; 0000 03ED nop ;7
nop ;7
; 0000 03EE nop ;8
nop ;8
; 0000 03EF nop ;9
nop ;9
; 0000 03F0 nop ;10
nop ;10
; 0000 03F1 nop ;11
nop ;11
; 0000 03F2 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 03F3 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 03F4     inc r19 ;16
    inc r19 ;16
; 0000 03F5      out PORTC,r19 ;1-16
     out PORTC,r19 ;1-16
; 0000 03F6 nop ;2
nop ;2
; 0000 03F7 nop ;3
nop ;3
; 0000 03F8 nop ;4
nop ;4
; 0000 03F9 nop ;5
nop ;5
; 0000 03FA nop ;6
nop ;6
; 0000 03FB nop ;7
nop ;7
; 0000 03FC nop ;8
nop ;8
; 0000 03FD nop ;9
nop ;9
; 0000 03FE nop ;10
nop ;10
; 0000 03FF nop ;11
nop ;11
; 0000 0400 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0401 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0402     inc r19 ;16
    inc r19 ;16
; 0000 0403      out PORTC,r19 ;1-17
     out PORTC,r19 ;1-17
; 0000 0404 nop ;2
nop ;2
; 0000 0405 nop ;3
nop ;3
; 0000 0406 nop ;4
nop ;4
; 0000 0407 nop ;5
nop ;5
; 0000 0408 nop ;6
nop ;6
; 0000 0409 nop ;7
nop ;7
; 0000 040A nop ;8
nop ;8
; 0000 040B nop ;9
nop ;9
; 0000 040C nop ;10
nop ;10
; 0000 040D nop ;11
nop ;11
; 0000 040E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 040F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0410     inc r19 ;16
    inc r19 ;16
; 0000 0411      out PORTC,r19 ;1-18
     out PORTC,r19 ;1-18
; 0000 0412 nop ;2
nop ;2
; 0000 0413 nop ;3
nop ;3
; 0000 0414 nop ;4
nop ;4
; 0000 0415 nop ;5
nop ;5
; 0000 0416 nop ;6
nop ;6
; 0000 0417 nop ;7
nop ;7
; 0000 0418 nop ;8
nop ;8
; 0000 0419 nop ;9
nop ;9
; 0000 041A nop ;10
nop ;10
; 0000 041B nop ;11
nop ;11
; 0000 041C cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 041D SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 041E     inc r19 ;16
    inc r19 ;16
; 0000 041F      out PORTC,r19 ;1-19
     out PORTC,r19 ;1-19
; 0000 0420 nop ;2
nop ;2
; 0000 0421 nop ;3
nop ;3
; 0000 0422 nop ;4
nop ;4
; 0000 0423 nop ;5
nop ;5
; 0000 0424 nop ;6
nop ;6
; 0000 0425 nop ;7
nop ;7
; 0000 0426 nop ;8
nop ;8
; 0000 0427 nop ;9
nop ;9
; 0000 0428 nop ;10
nop ;10
; 0000 0429 nop ;11
nop ;11
; 0000 042A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 042B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 042C     inc r19 ;16
    inc r19 ;16
; 0000 042D      out PORTC,r19 ;1-20
     out PORTC,r19 ;1-20
; 0000 042E nop ;2
nop ;2
; 0000 042F nop ;3
nop ;3
; 0000 0430 nop ;4
nop ;4
; 0000 0431 nop ;5
nop ;5
; 0000 0432 nop ;6
nop ;6
; 0000 0433 nop ;7
nop ;7
; 0000 0434 nop ;8
nop ;8
; 0000 0435 nop ;9
nop ;9
; 0000 0436 nop ;10
nop ;10
; 0000 0437 nop ;11
nop ;11
; 0000 0438 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0439 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 043A     inc r19 ;16
    inc r19 ;16
; 0000 043B      out PORTC,r19 ;1-21
     out PORTC,r19 ;1-21
; 0000 043C nop ;2
nop ;2
; 0000 043D nop ;3
nop ;3
; 0000 043E nop ;4
nop ;4
; 0000 043F nop ;5
nop ;5
; 0000 0440 nop ;6
nop ;6
; 0000 0441 nop ;7
nop ;7
; 0000 0442 nop ;8
nop ;8
; 0000 0443 nop ;9
nop ;9
; 0000 0444 nop ;10
nop ;10
; 0000 0445 nop ;11
nop ;11
; 0000 0446 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0447 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0448     inc r19 ;16
    inc r19 ;16
; 0000 0449      out PORTC,r19 ;1-22
     out PORTC,r19 ;1-22
; 0000 044A nop ;2
nop ;2
; 0000 044B nop ;3
nop ;3
; 0000 044C nop ;4
nop ;4
; 0000 044D nop ;5
nop ;5
; 0000 044E nop ;6
nop ;6
; 0000 044F nop ;7
nop ;7
; 0000 0450 nop ;8
nop ;8
; 0000 0451 nop ;9
nop ;9
; 0000 0452 nop ;10
nop ;10
; 0000 0453 nop ;11
nop ;11
; 0000 0454 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0455 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0456     inc r19 ;16
    inc r19 ;16
; 0000 0457      out PORTC,r19 ;1-23
     out PORTC,r19 ;1-23
; 0000 0458 nop ;2
nop ;2
; 0000 0459 nop ;3
nop ;3
; 0000 045A nop ;4
nop ;4
; 0000 045B nop ;5
nop ;5
; 0000 045C nop ;6
nop ;6
; 0000 045D nop ;7
nop ;7
; 0000 045E nop ;8
nop ;8
; 0000 045F nop ;9
nop ;9
; 0000 0460 nop ;10
nop ;10
; 0000 0461 nop ;11
nop ;11
; 0000 0462 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0463 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0464     inc r19 ;16
    inc r19 ;16
; 0000 0465      out PORTC,r19 ;1-24
     out PORTC,r19 ;1-24
; 0000 0466 nop ;2
nop ;2
; 0000 0467 nop ;3
nop ;3
; 0000 0468 nop ;4
nop ;4
; 0000 0469 nop ;5
nop ;5
; 0000 046A nop ;6
nop ;6
; 0000 046B nop ;7
nop ;7
; 0000 046C nop ;8
nop ;8
; 0000 046D nop ;9
nop ;9
; 0000 046E nop ;10
nop ;10
; 0000 046F nop ;11
nop ;11
; 0000 0470 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0471 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0472     inc r19 ;16
    inc r19 ;16
; 0000 0473      out PORTC,r19 ;1-25
     out PORTC,r19 ;1-25
; 0000 0474 nop ;2
nop ;2
; 0000 0475 nop ;3
nop ;3
; 0000 0476 nop ;4
nop ;4
; 0000 0477 nop ;5
nop ;5
; 0000 0478 nop ;6
nop ;6
; 0000 0479 nop ;7
nop ;7
; 0000 047A nop ;8
nop ;8
; 0000 047B nop ;9
nop ;9
; 0000 047C nop ;10
nop ;10
; 0000 047D nop ;11
nop ;11
; 0000 047E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 047F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0480     inc r19 ;16
    inc r19 ;16
; 0000 0481      out PORTC,r19 ;1-26
     out PORTC,r19 ;1-26
; 0000 0482 nop ;2
nop ;2
; 0000 0483 nop ;3
nop ;3
; 0000 0484 nop ;4
nop ;4
; 0000 0485 nop ;5
nop ;5
; 0000 0486 nop ;6
nop ;6
; 0000 0487 nop ;7
nop ;7
; 0000 0488 nop ;8
nop ;8
; 0000 0489 nop ;9
nop ;9
; 0000 048A nop ;10
nop ;10
; 0000 048B nop ;11
nop ;11
; 0000 048C cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 048D SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 048E     inc r19 ;16
    inc r19 ;16
; 0000 048F      out PORTC,r19 ;1-27
     out PORTC,r19 ;1-27
; 0000 0490 nop ;2
nop ;2
; 0000 0491 nop ;3
nop ;3
; 0000 0492 nop ;4
nop ;4
; 0000 0493 nop ;5
nop ;5
; 0000 0494 nop ;6
nop ;6
; 0000 0495 nop ;7
nop ;7
; 0000 0496 nop ;8
nop ;8
; 0000 0497 nop ;9
nop ;9
; 0000 0498 nop ;10
nop ;10
; 0000 0499 nop ;11
nop ;11
; 0000 049A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 049B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 049C     inc r19 ;16
    inc r19 ;16
; 0000 049D      out PORTC,r19 ;1-28
     out PORTC,r19 ;1-28
; 0000 049E nop ;2
nop ;2
; 0000 049F nop ;3
nop ;3
; 0000 04A0 nop ;4
nop ;4
; 0000 04A1 nop ;5
nop ;5
; 0000 04A2 nop ;6
nop ;6
; 0000 04A3 nop ;7
nop ;7
; 0000 04A4 nop ;8
nop ;8
; 0000 04A5 nop ;9
nop ;9
; 0000 04A6 nop ;10
nop ;10
; 0000 04A7 nop ;11
nop ;11
; 0000 04A8 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04A9 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04AA     inc r19 ;16
    inc r19 ;16
; 0000 04AB      out PORTC,r19 ;1-29
     out PORTC,r19 ;1-29
; 0000 04AC nop ;2
nop ;2
; 0000 04AD nop ;3
nop ;3
; 0000 04AE nop ;4
nop ;4
; 0000 04AF nop ;5
nop ;5
; 0000 04B0 nop ;6
nop ;6
; 0000 04B1 nop ;7
nop ;7
; 0000 04B2 nop ;8
nop ;8
; 0000 04B3 nop ;9
nop ;9
; 0000 04B4 nop ;10
nop ;10
; 0000 04B5 nop ;11
nop ;11
; 0000 04B6 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04B7 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04B8     inc r19 ;16
    inc r19 ;16
; 0000 04B9      out PORTC,r19 ;1-30
     out PORTC,r19 ;1-30
; 0000 04BA nop ;2
nop ;2
; 0000 04BB nop ;3
nop ;3
; 0000 04BC nop ;4
nop ;4
; 0000 04BD nop ;5
nop ;5
; 0000 04BE nop ;6
nop ;6
; 0000 04BF nop ;7
nop ;7
; 0000 04C0 nop ;8
nop ;8
; 0000 04C1 nop ;9
nop ;9
; 0000 04C2 nop ;10
nop ;10
; 0000 04C3 nop ;11
nop ;11
; 0000 04C4 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04C5 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04C6     inc r19 ;16
    inc r19 ;16
; 0000 04C7      out PORTC,r19 ;1-31
     out PORTC,r19 ;1-31
; 0000 04C8 nop ;2
nop ;2
; 0000 04C9 nop ;3
nop ;3
; 0000 04CA nop ;4
nop ;4
; 0000 04CB nop ;5
nop ;5
; 0000 04CC nop ;6
nop ;6
; 0000 04CD nop ;7
nop ;7
; 0000 04CE nop ;8
nop ;8
; 0000 04CF nop ;9
nop ;9
; 0000 04D0 nop ;10
nop ;10
; 0000 04D1 nop ;11
nop ;11
; 0000 04D2 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04D3 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04D4     inc r19 ;16
    inc r19 ;16
; 0000 04D5      out PORTC,r19 ;1-32
     out PORTC,r19 ;1-32
; 0000 04D6 nop ;2
nop ;2
; 0000 04D7 nop ;3
nop ;3
; 0000 04D8 nop ;4
nop ;4
; 0000 04D9 nop ;5
nop ;5
; 0000 04DA nop ;6
nop ;6
; 0000 04DB nop ;7
nop ;7
; 0000 04DC nop ;8
nop ;8
; 0000 04DD nop ;9
nop ;9
; 0000 04DE nop ;10
nop ;10
; 0000 04DF nop ;11
nop ;11
; 0000 04E0 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04E1 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04E2     inc r19 ;16
    inc r19 ;16
; 0000 04E3      out PORTC,r19 ;1-33
     out PORTC,r19 ;1-33
; 0000 04E4 nop ;2
nop ;2
; 0000 04E5 nop ;3
nop ;3
; 0000 04E6 nop ;4
nop ;4
; 0000 04E7 nop ;5
nop ;5
; 0000 04E8 nop ;6
nop ;6
; 0000 04E9 nop ;7
nop ;7
; 0000 04EA nop ;8
nop ;8
; 0000 04EB nop ;9
nop ;9
; 0000 04EC nop ;10
nop ;10
; 0000 04ED nop ;11
nop ;11
; 0000 04EE cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04EF SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04F0     inc r19 ;16
    inc r19 ;16
; 0000 04F1      out PORTC,r19 ;1-34
     out PORTC,r19 ;1-34
; 0000 04F2 nop ;2
nop ;2
; 0000 04F3 nop ;3
nop ;3
; 0000 04F4 nop ;4
nop ;4
; 0000 04F5 nop ;5
nop ;5
; 0000 04F6 nop ;6
nop ;6
; 0000 04F7 nop ;7
nop ;7
; 0000 04F8 nop ;8
nop ;8
; 0000 04F9 nop ;9
nop ;9
; 0000 04FA nop ;10
nop ;10
; 0000 04FB nop ;11
nop ;11
; 0000 04FC cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 04FD SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 04FE     inc r19 ;16
    inc r19 ;16
; 0000 04FF      out PORTC,r19 ;1-35
     out PORTC,r19 ;1-35
; 0000 0500 nop ;2
nop ;2
; 0000 0501 nop ;3
nop ;3
; 0000 0502 nop ;4
nop ;4
; 0000 0503 nop ;5
nop ;5
; 0000 0504 nop ;6
nop ;6
; 0000 0505 nop ;7
nop ;7
; 0000 0506 nop ;8
nop ;8
; 0000 0507 nop ;9
nop ;9
; 0000 0508 nop ;10
nop ;10
; 0000 0509 nop ;11
nop ;11
; 0000 050A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 050B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 050C     inc r19 ;16
    inc r19 ;16
; 0000 050D      out PORTC,r19 ;1-36
     out PORTC,r19 ;1-36
; 0000 050E nop ;2
nop ;2
; 0000 050F nop ;3
nop ;3
; 0000 0510 nop ;4
nop ;4
; 0000 0511 nop ;5
nop ;5
; 0000 0512 nop ;6
nop ;6
; 0000 0513 nop ;7
nop ;7
; 0000 0514 nop ;8
nop ;8
; 0000 0515 nop ;9
nop ;9
; 0000 0516 nop ;10
nop ;10
; 0000 0517 nop ;11
nop ;11
; 0000 0518 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0519 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 051A     inc r19 ;16
    inc r19 ;16
; 0000 051B      out PORTC,r19 ;1-37
     out PORTC,r19 ;1-37
; 0000 051C nop ;2
nop ;2
; 0000 051D nop ;3
nop ;3
; 0000 051E nop ;4
nop ;4
; 0000 051F nop ;5
nop ;5
; 0000 0520 nop ;6
nop ;6
; 0000 0521 nop ;7
nop ;7
; 0000 0522 nop ;8
nop ;8
; 0000 0523 nop ;9
nop ;9
; 0000 0524 nop ;10
nop ;10
; 0000 0525 nop ;11
nop ;11
; 0000 0526 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0527 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0528     inc r19 ;16
    inc r19 ;16
; 0000 0529      out PORTC,r19 ;1-38
     out PORTC,r19 ;1-38
; 0000 052A nop ;2
nop ;2
; 0000 052B nop ;3
nop ;3
; 0000 052C nop ;4
nop ;4
; 0000 052D nop ;5
nop ;5
; 0000 052E nop ;6
nop ;6
; 0000 052F nop ;7
nop ;7
; 0000 0530 nop ;8
nop ;8
; 0000 0531 nop ;9
nop ;9
; 0000 0532 nop ;10
nop ;10
; 0000 0533 nop ;11
nop ;11
; 0000 0534 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0535 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0536     inc r19 ;16
    inc r19 ;16
; 0000 0537      out PORTC,r19 ;1-39
     out PORTC,r19 ;1-39
; 0000 0538 nop ;2
nop ;2
; 0000 0539 nop ;3
nop ;3
; 0000 053A nop ;4
nop ;4
; 0000 053B nop ;5
nop ;5
; 0000 053C nop ;6
nop ;6
; 0000 053D nop ;7
nop ;7
; 0000 053E nop ;8
nop ;8
; 0000 053F nop ;9
nop ;9
; 0000 0540 nop ;10
nop ;10
; 0000 0541 nop ;11
nop ;11
; 0000 0542 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0543 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0544     inc r19 ;16
    inc r19 ;16
; 0000 0545      out PORTC,r19 ;1-40
     out PORTC,r19 ;1-40
; 0000 0546 nop ;2
nop ;2
; 0000 0547 nop ;3
nop ;3
; 0000 0548 nop ;4
nop ;4
; 0000 0549 nop ;5
nop ;5
; 0000 054A nop ;6
nop ;6
; 0000 054B nop ;7
nop ;7
; 0000 054C nop ;8
nop ;8
; 0000 054D nop ;9
nop ;9
; 0000 054E nop ;10
nop ;10
; 0000 054F nop ;11
nop ;11
; 0000 0550 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0551 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0552     inc r19 ;16
    inc r19 ;16
; 0000 0553      out PORTC,r19 ;1-41
     out PORTC,r19 ;1-41
; 0000 0554 nop ;2
nop ;2
; 0000 0555 nop ;3
nop ;3
; 0000 0556 nop ;4
nop ;4
; 0000 0557 nop ;5
nop ;5
; 0000 0558 nop ;6
nop ;6
; 0000 0559 nop ;7
nop ;7
; 0000 055A nop ;8
nop ;8
; 0000 055B nop ;9
nop ;9
; 0000 055C nop ;10
nop ;10
; 0000 055D nop ;11
nop ;11
; 0000 055E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 055F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0560     inc r19 ;16
    inc r19 ;16
; 0000 0561     out PORTC,r19 ;1-42
    out PORTC,r19 ;1-42
; 0000 0562 nop ;2
nop ;2
; 0000 0563 nop ;3
nop ;3
; 0000 0564 nop ;4
nop ;4
; 0000 0565 nop ;5
nop ;5
; 0000 0566 nop ;6
nop ;6
; 0000 0567 nop ;7
nop ;7
; 0000 0568 nop ;8
nop ;8
; 0000 0569 nop ;9
nop ;9
; 0000 056A nop ;10
nop ;10
; 0000 056B nop ;11
nop ;11
; 0000 056C cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 056D SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 056E     inc r19 ;16
    inc r19 ;16
; 0000 056F      out PORTC,r19 ;1-43
     out PORTC,r19 ;1-43
; 0000 0570 nop ;2
nop ;2
; 0000 0571 nop ;3
nop ;3
; 0000 0572 nop ;4
nop ;4
; 0000 0573 nop ;5
nop ;5
; 0000 0574 nop ;6
nop ;6
; 0000 0575 nop ;7
nop ;7
; 0000 0576 nop ;8
nop ;8
; 0000 0577 nop ;9
nop ;9
; 0000 0578 nop ;10
nop ;10
; 0000 0579 nop ;11
nop ;11
; 0000 057A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 057B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 057C     inc r19 ;16
    inc r19 ;16
; 0000 057D      out PORTC,r19 ;1-44
     out PORTC,r19 ;1-44
; 0000 057E nop ;2
nop ;2
; 0000 057F nop ;3
nop ;3
; 0000 0580 nop ;4
nop ;4
; 0000 0581 nop ;5
nop ;5
; 0000 0582 nop ;6
nop ;6
; 0000 0583 nop ;7
nop ;7
; 0000 0584 nop ;8
nop ;8
; 0000 0585 nop ;9
nop ;9
; 0000 0586 nop ;10
nop ;10
; 0000 0587 nop ;11
nop ;11
; 0000 0588 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0589 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 058A     inc r19 ;16
    inc r19 ;16
; 0000 058B      out PORTC,r19 ;1-45
     out PORTC,r19 ;1-45
; 0000 058C nop ;2
nop ;2
; 0000 058D nop ;3
nop ;3
; 0000 058E nop ;4
nop ;4
; 0000 058F nop ;5
nop ;5
; 0000 0590 nop ;6
nop ;6
; 0000 0591 nop ;7
nop ;7
; 0000 0592 nop ;8
nop ;8
; 0000 0593 nop ;9
nop ;9
; 0000 0594 nop ;10
nop ;10
; 0000 0595 nop ;11
nop ;11
; 0000 0596 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0597 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0598     inc r19 ;16
    inc r19 ;16
; 0000 0599      out PORTC,r19 ;1-46
     out PORTC,r19 ;1-46
; 0000 059A nop ;2
nop ;2
; 0000 059B nop ;3
nop ;3
; 0000 059C nop ;4
nop ;4
; 0000 059D nop ;5
nop ;5
; 0000 059E nop ;6
nop ;6
; 0000 059F nop ;7
nop ;7
; 0000 05A0 nop ;8
nop ;8
; 0000 05A1 nop ;9
nop ;9
; 0000 05A2 nop ;10
nop ;10
; 0000 05A3 nop ;11
nop ;11
; 0000 05A4 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05A5 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05A6     inc r19 ;16
    inc r19 ;16
; 0000 05A7      out PORTC,r19 ;1-47
     out PORTC,r19 ;1-47
; 0000 05A8 nop ;2
nop ;2
; 0000 05A9 nop ;3
nop ;3
; 0000 05AA nop ;4
nop ;4
; 0000 05AB nop ;5
nop ;5
; 0000 05AC nop ;6
nop ;6
; 0000 05AD nop ;7
nop ;7
; 0000 05AE nop ;8
nop ;8
; 0000 05AF nop ;9
nop ;9
; 0000 05B0 nop ;10
nop ;10
; 0000 05B1 nop ;11
nop ;11
; 0000 05B2 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05B3 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05B4     inc r19 ;16
    inc r19 ;16
; 0000 05B5      out PORTC,r19 ;1-48
     out PORTC,r19 ;1-48
; 0000 05B6 nop ;2
nop ;2
; 0000 05B7 nop ;3
nop ;3
; 0000 05B8 nop ;4
nop ;4
; 0000 05B9 nop ;5
nop ;5
; 0000 05BA nop ;6
nop ;6
; 0000 05BB nop ;7
nop ;7
; 0000 05BC nop ;8
nop ;8
; 0000 05BD nop ;9
nop ;9
; 0000 05BE nop ;10
nop ;10
; 0000 05BF nop ;11
nop ;11
; 0000 05C0 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05C1 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05C2     inc r19 ;16
    inc r19 ;16
; 0000 05C3      out PORTC,r19 ;1-49
     out PORTC,r19 ;1-49
; 0000 05C4 nop ;2
nop ;2
; 0000 05C5 nop ;3
nop ;3
; 0000 05C6 nop ;4
nop ;4
; 0000 05C7 nop ;5
nop ;5
; 0000 05C8 nop ;6
nop ;6
; 0000 05C9 nop ;7
nop ;7
; 0000 05CA nop ;8
nop ;8
; 0000 05CB nop ;9
nop ;9
; 0000 05CC nop ;10
nop ;10
; 0000 05CD nop ;11
nop ;11
; 0000 05CE cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05CF SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05D0     inc r19 ;16
    inc r19 ;16
; 0000 05D1      out PORTC,r19 ;1-50
     out PORTC,r19 ;1-50
; 0000 05D2 nop ;2
nop ;2
; 0000 05D3 nop ;3
nop ;3
; 0000 05D4 nop ;4
nop ;4
; 0000 05D5 nop ;5
nop ;5
; 0000 05D6 nop ;6
nop ;6
; 0000 05D7 nop ;7
nop ;7
; 0000 05D8 nop ;8
nop ;8
; 0000 05D9 nop ;9
nop ;9
; 0000 05DA nop ;10
nop ;10
; 0000 05DB nop ;11
nop ;11
; 0000 05DC cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05DD SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05DE     inc r19 ;16
    inc r19 ;16
; 0000 05DF      out PORTC,r19 ;1-51
     out PORTC,r19 ;1-51
; 0000 05E0 nop ;2
nop ;2
; 0000 05E1 nop ;3
nop ;3
; 0000 05E2 nop ;4
nop ;4
; 0000 05E3 nop ;5
nop ;5
; 0000 05E4 nop ;6
nop ;6
; 0000 05E5 nop ;7
nop ;7
; 0000 05E6 nop ;8
nop ;8
; 0000 05E7 nop ;9
nop ;9
; 0000 05E8 nop ;10
nop ;10
; 0000 05E9 nop ;11
nop ;11
; 0000 05EA cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05EB SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05EC     inc r19 ;16
    inc r19 ;16
; 0000 05ED      out PORTC,r19 ;1-52
     out PORTC,r19 ;1-52
; 0000 05EE nop ;2
nop ;2
; 0000 05EF nop ;3
nop ;3
; 0000 05F0 nop ;4
nop ;4
; 0000 05F1 nop ;5
nop ;5
; 0000 05F2 nop ;6
nop ;6
; 0000 05F3 nop ;7
nop ;7
; 0000 05F4 nop ;8
nop ;8
; 0000 05F5 nop ;9
nop ;9
; 0000 05F6 nop ;10
nop ;10
; 0000 05F7 nop ;11
nop ;11
; 0000 05F8 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 05F9 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 05FA     inc r19 ;16
    inc r19 ;16
; 0000 05FB      out PORTC,r19 ;1-53
     out PORTC,r19 ;1-53
; 0000 05FC nop ;2
nop ;2
; 0000 05FD nop ;3
nop ;3
; 0000 05FE nop ;4
nop ;4
; 0000 05FF nop ;5
nop ;5
; 0000 0600 nop ;6
nop ;6
; 0000 0601 nop ;7
nop ;7
; 0000 0602 nop ;8
nop ;8
; 0000 0603 nop ;9
nop ;9
; 0000 0604 nop ;10
nop ;10
; 0000 0605 nop ;11
nop ;11
; 0000 0606 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0607 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0608     inc r19 ;16
    inc r19 ;16
; 0000 0609      out PORTC,r19 ;1-54
     out PORTC,r19 ;1-54
; 0000 060A nop ;2
nop ;2
; 0000 060B nop ;3
nop ;3
; 0000 060C nop ;4
nop ;4
; 0000 060D nop ;5
nop ;5
; 0000 060E nop ;6
nop ;6
; 0000 060F nop ;7
nop ;7
; 0000 0610 nop ;8
nop ;8
; 0000 0611 nop ;9
nop ;9
; 0000 0612 nop ;10
nop ;10
; 0000 0613 nop ;11
nop ;11
; 0000 0614 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0615 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0616     inc r19 ;16
    inc r19 ;16
; 0000 0617      out PORTC,r19 ;1-55
     out PORTC,r19 ;1-55
; 0000 0618 nop ;2
nop ;2
; 0000 0619 nop ;3
nop ;3
; 0000 061A nop ;4
nop ;4
; 0000 061B nop ;5
nop ;5
; 0000 061C nop ;6
nop ;6
; 0000 061D nop ;7
nop ;7
; 0000 061E nop ;8
nop ;8
; 0000 061F nop ;9
nop ;9
; 0000 0620 nop ;10
nop ;10
; 0000 0621 nop ;11
nop ;11
; 0000 0622 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0623 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0624     inc r19 ;16
    inc r19 ;16
; 0000 0625      out PORTC,r19 ;1-56
     out PORTC,r19 ;1-56
; 0000 0626 nop ;2
nop ;2
; 0000 0627 nop ;3
nop ;3
; 0000 0628 nop ;4
nop ;4
; 0000 0629 nop ;5
nop ;5
; 0000 062A nop ;6
nop ;6
; 0000 062B nop ;7
nop ;7
; 0000 062C nop ;8
nop ;8
; 0000 062D nop ;9
nop ;9
; 0000 062E nop ;10
nop ;10
; 0000 062F nop ;11
nop ;11
; 0000 0630 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0631 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0632     inc r19 ;16
    inc r19 ;16
; 0000 0633      out PORTC,r19 ;1-57
     out PORTC,r19 ;1-57
; 0000 0634 nop ;2
nop ;2
; 0000 0635 nop ;3
nop ;3
; 0000 0636 nop ;4
nop ;4
; 0000 0637 nop ;5
nop ;5
; 0000 0638 nop ;6
nop ;6
; 0000 0639 nop ;7
nop ;7
; 0000 063A nop ;8
nop ;8
; 0000 063B nop ;9
nop ;9
; 0000 063C nop ;10
nop ;10
; 0000 063D nop ;11
nop ;11
; 0000 063E cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 063F SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0640     inc r19 ;16
    inc r19 ;16
; 0000 0641      out PORTC,r19 ;1-58
     out PORTC,r19 ;1-58
; 0000 0642 nop ;2
nop ;2
; 0000 0643 nop ;3
nop ;3
; 0000 0644 nop ;4
nop ;4
; 0000 0645 nop ;5
nop ;5
; 0000 0646 nop ;6
nop ;6
; 0000 0647 nop ;7
nop ;7
; 0000 0648 nop ;8
nop ;8
; 0000 0649 nop ;9
nop ;9
; 0000 064A nop ;10
nop ;10
; 0000 064B nop ;11
nop ;11
; 0000 064C cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 064D SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 064E     inc r19 ;16
    inc r19 ;16
; 0000 064F      out PORTC,r19 ;1-59
     out PORTC,r19 ;1-59
; 0000 0650 nop ;2
nop ;2
; 0000 0651 nop ;3
nop ;3
; 0000 0652 nop ;4
nop ;4
; 0000 0653 nop ;5
nop ;5
; 0000 0654 nop ;6
nop ;6
; 0000 0655 nop ;7
nop ;7
; 0000 0656 nop ;8
nop ;8
; 0000 0657 nop ;9
nop ;9
; 0000 0658 nop ;10
nop ;10
; 0000 0659 nop ;11
nop ;11
; 0000 065A cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 065B SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 065C     inc r19 ;16
    inc r19 ;16
; 0000 065D      out PORTC,r19 ;1-60
     out PORTC,r19 ;1-60
; 0000 065E nop ;2
nop ;2
; 0000 065F nop ;3
nop ;3
; 0000 0660 nop ;4
nop ;4
; 0000 0661 nop ;5
nop ;5
; 0000 0662 nop ;6
nop ;6
; 0000 0663 nop ;7
nop ;7
; 0000 0664 nop ;8
nop ;8
; 0000 0665 nop ;9
nop ;9
; 0000 0666 nop ;10
nop ;10
; 0000 0667 nop ;11
nop ;11
; 0000 0668 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0669 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 066A     inc r19 ;16
    inc r19 ;16
; 0000 066B      out PORTC,r19 ;1-61
     out PORTC,r19 ;1-61
; 0000 066C nop ;2
nop ;2
; 0000 066D nop ;3
nop ;3
; 0000 066E nop ;4
nop ;4
; 0000 066F nop ;5
nop ;5
; 0000 0670 nop ;6
nop ;6
; 0000 0671 nop ;7
nop ;7
; 0000 0672 nop ;8
nop ;8
; 0000 0673 nop ;9
nop ;9
; 0000 0674 nop ;10
nop ;10
; 0000 0675 nop ;11
nop ;11
; 0000 0676 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0677 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0678     inc r19 ;16
    inc r19 ;16
; 0000 0679      out PORTC,r19 ;1-62
     out PORTC,r19 ;1-62
; 0000 067A nop ;2
nop ;2
; 0000 067B nop ;3
nop ;3
; 0000 067C nop ;4
nop ;4
; 0000 067D nop ;5
nop ;5
; 0000 067E nop ;6
nop ;6
; 0000 067F nop ;7
nop ;7
; 0000 0680 nop ;8
nop ;8
; 0000 0681 nop ;9
nop ;9
; 0000 0682 nop ;10
nop ;10
; 0000 0683 nop ;11
nop ;11
; 0000 0684 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0685 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0686     inc r19 ;16
    inc r19 ;16
; 0000 0687      out PORTC,r19 ;1-63
     out PORTC,r19 ;1-63
; 0000 0688 nop ;2
nop ;2
; 0000 0689 nop ;3
nop ;3
; 0000 068A nop ;4
nop ;4
; 0000 068B nop ;5
nop ;5
; 0000 068C nop ;6
nop ;6
; 0000 068D nop ;7
nop ;7
; 0000 068E nop ;8
nop ;8
; 0000 068F nop ;9
nop ;9
; 0000 0690 nop ;10
nop ;10
; 0000 0691 nop ;11
nop ;11
; 0000 0692 cbi PORTB,4 ;12-13 Strob ON
cbi PORTB,4 ;12-13 Strob ON
; 0000 0693 SBI PORTB,4 ;14-15 Strob OFF
SBI PORTB,4 ;14-15 Strob OFF
; 0000 0694 nop ;16
nop ;16
; 0000 0695 nop ;1
nop ;1
; 0000 0696 nop ;2
nop ;2
; 0000 0697 nop ;3
nop ;3
; 0000 0698 nop ;4
nop ;4
; 0000 0699 nop ;5
nop ;5
; 0000 069A nop ;6
nop ;6
; 0000 069B nop ;7
nop ;7
; 0000 069C nop ;8
nop ;8
; 0000 069D nop ;9
nop ;9
; 0000 069E nop ;10
nop ;10
; 0000 069F nop ;11
nop ;11
; 0000 06A0 nop ;12
nop ;12
; 0000 06A1 nop ;13
nop ;13
; 0000 06A2 nop ;14
nop ;14
; 0000 06A3     cbi  PORTB,3;16-17  Blank =0
    cbi  PORTB,3;16-17  Blank =0
; 0000 06A4     clr r19 ;18
    clr r19 ;18
; 0000 06A5     out PORTC,r19 ;19
    out PORTC,r19 ;19
; 0000 06A6 

; 0000 06A7 #endasm
; 0000 06A8  L2:
_0x15:
; 0000 06A9        V++; //
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 5,6,30,31
; 0000 06AA  L1:
_0xC:
; 0000 06AB    CV++;  //
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 3,4,30,31
; 0000 06AC }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R25,Y+
	LD   R24,Y+
	RETI
;
;// Declare your global variables here
;
;void main(void)
; 0000 06B1 {
_main:
; 0000 06B2 // Declare your local variables here
; 0000 06B3 
; 0000 06B4 // Crystal Oscillator division factor: 1
; 0000 06B5 #pragma optsize-
; 0000 06B6 CLKPR=0x80;
	LDI  R30,LOW(128)
	STS  97,R30
; 0000 06B7 CLKPR=0x00;
	LDI  R30,LOW(0)
	STS  97,R30
; 0000 06B8 #ifdef _OPTIMIZE_SIZE_
; 0000 06B9 #pragma optsize+
; 0000 06BA #endif
; 0000 06BB 
; 0000 06BC // Input/Output Ports initialization
; 0000 06BD // Port B initialization
; 0000 06BE // Func7=In Func6=In Func5=In Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 06BF // State7=T State6=T State5=P State4=1 State3=1 State2=1 State1=1 State0=1
; 0000 06C0 PORTB=0x3F;
	LDI  R30,LOW(63)
	OUT  0x5,R30
; 0000 06C1 DDRB=0x1F;
	LDI  R30,LOW(31)
	OUT  0x4,R30
; 0000 06C2 
; 0000 06C3 // Port C initialization
; 0000 06C4 // Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 06C5 // State6=T State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 06C6 PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x8,R30
; 0000 06C7 DDRC=0x3F;
	LDI  R30,LOW(63)
	OUT  0x7,R30
; 0000 06C8 
; 0000 06C9 // Port D initialization
; 0000 06CA // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 06CB // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 06CC PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 06CD DDRD=0xFF;
	LDI  R30,LOW(255)
	OUT  0xA,R30
; 0000 06CE 
; 0000 06CF // Timer/Counter 0 initialization
; 0000 06D0 // Clock source: System Clock
; 0000 06D1 // Clock value: Timer 0 Stopped
; 0000 06D2 // Mode: Normal top=FFh
; 0000 06D3 // OC0A output: Disconnected
; 0000 06D4 // OC0B output: Disconnected
; 0000 06D5 TCCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x24,R30
; 0000 06D6 TCCR0B=0x00;
	OUT  0x25,R30
; 0000 06D7 TCNT0=0x00;
	OUT  0x26,R30
; 0000 06D8 OCR0A=0x00;
	OUT  0x27,R30
; 0000 06D9 OCR0B=0x00;
	OUT  0x28,R30
; 0000 06DA 
; 0000 06DB // Timer/Counter 1 initialization
; 0000 06DC // Clock source: System Clock
; 0000 06DD // Clock value: 22118,000 kHz
; 0000 06DE // Mode: Fast PWM top=ICR1
; 0000 06DF // OC1A output: Inverted
; 0000 06E0 // OC1B output: Discon.
; 0000 06E1 // Noise Canceler: Off
; 0000 06E2 // Input Capture on Falling Edge
; 0000 06E3 // Timer1 Overflow Interrupt: Off
; 0000 06E4 // Input Capture Interrupt: Off
; 0000 06E5 // Compare A Match Interrupt: On
; 0000 06E6 // Compare B Match Interrupt: Off
; 0000 06E7 TCCR1A=0xC2;
	LDI  R30,LOW(194)
	STS  128,R30
; 0000 06E8 TCCR1B=0x19;
	LDI  R30,LOW(25)
	STS  129,R30
; 0000 06E9 TCNT1H=0x00;
	LDI  R30,LOW(0)
	STS  133,R30
; 0000 06EA TCNT1L=0x00;
	STS  132,R30
; 0000 06EB ICR1H=0x05;    // 
	LDI  R30,LOW(5)
	STS  135,R30
; 0000 06EC ICR1L=0x87;    //       
	LDI  R30,LOW(135)
	STS  134,R30
; 0000 06ED OCR1AH=0x00;   //
	LDI  R30,LOW(0)
	STS  137,R30
; 0000 06EE OCR1AL=0x67;   //            
	LDI  R30,LOW(103)
	STS  136,R30
; 0000 06EF OCR1BH=0x00;
	LDI  R30,LOW(0)
	STS  139,R30
; 0000 06F0 OCR1BL=0x00;
	STS  138,R30
; 0000 06F1 
; 0000 06F2 // Timer/Counter 2 initialization
; 0000 06F3 // Clock source: System Clock
; 0000 06F4 // Clock value: Timer2 Stopped
; 0000 06F5 // Mode: Normal top=FFh
; 0000 06F6 // OC2A output: Disconnected
; 0000 06F7 // OC2B output: Disconnected
; 0000 06F8 ASSR=0x00;
	STS  182,R30
; 0000 06F9 TCCR2A=0x00;
	STS  176,R30
; 0000 06FA TCCR2B=0x00;
	STS  177,R30
; 0000 06FB TCNT2=0x00;
	STS  178,R30
; 0000 06FC OCR2A=0x00;
	STS  179,R30
; 0000 06FD OCR2B=0x00;
	STS  180,R30
; 0000 06FE 
; 0000 06FF // External Interrupt(s) initialization
; 0000 0700 // INT0: Off
; 0000 0701 // INT1: Off
; 0000 0702 // Interrupt on any change on pins PCINT0-7: Off
; 0000 0703 // Interrupt on any change on pins PCINT8-14: Off
; 0000 0704 // Interrupt on any change on pins PCINT16-23: Off
; 0000 0705 EICRA=0x00;
	STS  105,R30
; 0000 0706 EIMSK=0x00;
	OUT  0x1D,R30
; 0000 0707 PCICR=0x00;
	STS  104,R30
; 0000 0708 
; 0000 0709 // Timer/Counter 0 Interrupt(s) initialization
; 0000 070A TIMSK0=0x00;
	STS  110,R30
; 0000 070B // Timer/Counter 1 Interrupt(s) initialization
; 0000 070C TIMSK1=0x02;
	LDI  R30,LOW(2)
	STS  111,R30
; 0000 070D // Timer/Counter 2 Interrupt(s) initialization
; 0000 070E TIMSK2=0x00;
	LDI  R30,LOW(0)
	STS  112,R30
; 0000 070F 
; 0000 0710 // Analog Comparator initialization
; 0000 0711 // Analog Comparator: Off
; 0000 0712 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 0713 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x30,R30
; 0000 0714 ADCSRB=0x00;
	LDI  R30,LOW(0)
	STS  123,R30
; 0000 0715 
; 0000 0716 // Global enable interrupts
; 0000 0717 #asm("sei")
	sei
; 0000 0718 
; 0000 0719 while (1)
_0x16:
; 0000 071A       {
; 0000 071B 
; 0000 071C 
; 0000 071D 
; 0000 071E       };
	RJMP _0x16
; 0000 071F }
_0x19:
	RJMP _0x19

	.CSEG

	.CSEG
;END OF CODE MARKER
__END_OF_CODE:
